/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.mixin.stats;

import java.util.BitSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.stats.RecipeBook;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import noppes.npcs.LogWriter;
import noppes.npcs.api.handler.data.INpcRecipe;
import noppes.npcs.api.mixin.stats.IRecipeBookMixin;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RecipeBook.class}, priority=499)
public class RecipeBookMixin
implements IRecipeBookMixin {
    @Mutable
    @Final
    @Shadow
    protected BitSet field_194077_a;
    @Mutable
    @Final
    @Shadow
    protected BitSet field_194078_b;

    @Inject(method={"unlock"}, at={@At(value="HEAD")}, cancellable=true)
    public void npcs$unlock(IRecipe recipe, CallbackInfo ci) {
        ci.cancel();
        int recipeID = this.npcs$getRecipeId(recipe);
        if (!recipe.func_192399_d() && recipeID != -1) {
            this.field_194077_a.set(recipeID);
        }
    }

    @Inject(method={"lock"}, at={@At(value="HEAD")}, cancellable=true)
    public void npcs$lock(IRecipe recipe, CallbackInfo ci) {
        ci.cancel();
        int recipeID = this.npcs$getRecipeId(recipe);
        if (recipeID != -1) {
            this.field_194077_a.clear(recipeID);
            this.field_194078_b.clear(recipeID);
        }
    }

    @Deprecated
    @Inject(method={"isUnlocked"}, at={@At(value="HEAD")}, cancellable=true)
    public void npcs$isUnlocked(IRecipe recipe, CallbackInfoReturnable<Boolean> cir) {
        if (this.npcs$getRecipeId(recipe) == -1) {
            cir.cancel();
            cir.setReturnValue((Object)false);
            LogWriter.error(String.format("Attempted to get the ID for a unknown recipe: %s Name: %s", recipe, recipe.getRegistryName()));
        }
    }

    @Override
    public RecipeBook npcs$copyToNew(boolean isGlobal, EntityPlayer player) {
        IRecipe irecipe;
        int id;
        RecipeBook newBook = new RecipeBook();
        for (id = 0; id < this.field_194077_a.length(); ++id) {
            if (!this.field_194077_a.get(id) || (irecipe = (IRecipe)CraftingManager.field_193380_a.func_148754_a(id)) == null || irecipe instanceof INpcRecipe && !((INpcRecipe)irecipe).isValid()) continue;
            if (isGlobal) {
                if (irecipe instanceof INpcRecipe && !((INpcRecipe)irecipe).isGlobal()) continue;
                newBook.func_194073_a(irecipe);
                continue;
            }
            if (!(irecipe instanceof INpcRecipe) || ((INpcRecipe)irecipe).isGlobal()) continue;
            newBook.func_194073_a(irecipe);
        }
        for (id = 0; id < this.field_194078_b.length(); ++id) {
            if (!this.field_194078_b.get(id) || (irecipe = (IRecipe)CraftingManager.field_193380_a.func_148754_a(id)) == null) continue;
            if (isGlobal) {
                if (irecipe instanceof INpcRecipe && !((INpcRecipe)irecipe).isGlobal()) continue;
                newBook.func_193825_e(irecipe);
                continue;
            }
            if (!(irecipe instanceof INpcRecipe) || ((INpcRecipe)irecipe).isGlobal()) continue;
            newBook.func_193825_e(irecipe);
        }
        return newBook;
    }

    @Override
    public boolean npcs$checkRecipes() {
        IRecipe irecipe;
        int id;
        boolean bo = true;
        BitSet recipesN = new BitSet();
        BitSet newRecipesN = new BitSet();
        for (id = 0; id < this.field_194077_a.length(); ++id) {
            if (!this.field_194077_a.get(id)) continue;
            irecipe = (IRecipe)CraftingManager.field_193380_a.func_148754_a(id);
            if (irecipe != null) {
                recipesN.set(id);
                continue;
            }
            bo = false;
        }
        for (id = 0; id < this.field_194078_b.length(); ++id) {
            if (!this.field_194078_b.get(id)) continue;
            irecipe = (IRecipe)CraftingManager.field_193380_a.func_148754_a(id);
            if (irecipe != null) {
                newRecipesN.set(id);
                continue;
            }
            bo = false;
        }
        if (!bo) {
            this.field_194077_a = recipesN;
            this.field_194078_b = newRecipesN;
        }
        return bo;
    }

    @Unique
    private int npcs$getRecipeId(IRecipe recipe) {
        int recipeID = CraftingManager.field_193380_a.func_148757_b((Object)recipe);
        if (recipeID == -1) {
            recipeID = ((ForgeRegistry)ForgeRegistries.RECIPES).getID(recipe.getRegistryName());
        }
        return recipeID;
    }
}

